//-------------------------------------------//
//                                           //
//           Marijus Verzbolauskas           //
//           IT, 1 gr.                       //
//                                           //
//-------------------------------------------//

#include <iostream>
#include <fstream>

using namespace std;

const int size = 100;

struct library
{
    string name;
    int number;
    bool given;
    char isFree;
    double countAll;
};

void initialize(int, int);
void insert(string name, int number, bool given, char isFree, double countAll, int i);
void retrieve(int i);
void Delete(int i);
void print(int);
void kill(int);
void load();
void save();
void showNext();

int h;
int t;

library cars[size]; 
    
int main()
{
    string name;
    int number;
    bool given;
    char isFree;
    double countAll;
    int i;
    
    load();
    for (;;)
    { 
        cout << " " << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|                                           |" << endl;
        cout << "|            Automobiliu nuoma              |" << endl;
        cout << "|                                           |" << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|  MENIU                                    |" << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|  1.Prideti nauja automobili               |" << endl;
        cout << "|  2.Spausdinti esamu aubomobiliu sarasa    |" << endl;
        cout << "|  3.Rasti automobili                       |" << endl;
        cout << "|  4.Trinti                                 |" << endl;
        cout << "|  5.Panaikinti sarasa                      |" << endl;
        cout << "|  6.Rodyti sekanti                         |" << endl;
        cout << "|                                           |" << endl;
        cout << "|  0.Iseiti                                 |" << endl;  
        cout << "---------------------------------------------" << endl;
        cout << "                                             " << endl;
        
        int key; cin >> key;
        system("cls");
        switch (key)
        {
            case 1:
                 cin.ignore(INT_MAX, '\n');
                 cout << "                              " << endl;
                 cout << "---------------------------------------------" << endl;
                 cout << "  Pavadinimas: "; getline(cin, name);
                 cout << "  Skaicius sadelyje: "; cin >> number;
                 cout << "  Ar nuomuojama? (0-ne / 1-taip): "; cin >> given;
                 cout << "  Ar yra laisvu automobiliu? (T / N): "; cin >> isFree;
                 cout << "  Buvo uzsakyta: "; cin >> countAll;
                 cout << "  Kurioje vietoje bus: "; cin >> i; 
                 cout << "---------------------------------------------" << endl;
                 cout << "                              " << endl;      
                 insert(name, number, given, isFree, countAll, i);   
                 break;
            case 2:
                 print(t);
                 break;
            case 3:
                 cout << " " << endl;
                 cout << "---------------------------------------------" << endl;
                 cout << "  Iveskite automobilio vieta: "; cin >> i;
                 cout << "---------------------------------------------" << endl;
                 cout << " " << endl;
                 retrieve(i);
                 break;
            case 4:
                 print(t);
                 cout << " " << endl;
                 cout << "---------------------------------------------" << endl;
                 cout << "  Iveskite trinamo automobilio vieta: "; cin >> i;
                 cout << "---------------------------------------------" << endl;
                 Delete(i);
                 break;
            case 5:
                 kill(size);
                 break;
            case 6:
                 showNext();
                 break;
            case 0:
                 save();
                 return 0;
        }
    }
}

void initialize(int head, int tail)
{
    h = head;
    t = tail;
}

void insert(string name, int number, bool given, char isFree, double countAll, int i)
{
     if (h == 0)
     initialize(1, t);
    if (cars[i].name != "")
    {
        for (int j = t+1; j > i; j--)
        {
            cars[j].name = cars[j-1].name;
            cars[j].number = cars[j-1].number;
            cars[j].given = cars[j-1].given;
            cars[j].isFree = cars[j-1].isFree;
            cars[j].countAll = cars[j-1].countAll;
        }
        cars[i].name = name;
        cars[i].number = number;
        cars[i].given = given;
        cars[i].isFree = isFree;
        cars[i].countAll = countAll;
    }
    if (i > t)
    {
        cars[t+1].name = name;
        cars[t+1].number = number;
        cars[t+1].given = given;
        cars[t+1].isFree = isFree;
        cars[t+1].countAll = countAll;
    }
    t++;
}

void print(int size)
{
    if (size == 0)
    {
        cout << "                              " << endl;
        cout << "                              " << endl;
        cout << "             AUTOMOBILIU NERA!" << endl;
        cout << "                              " << endl;
        cout << "                              " << endl;
    }
    else
    {
        cout << " " << endl;
        cout << "---------------------------------------------" << endl;
        cout << "|           AUTOMOBILIAI SANDELYJE          |" << endl;
        cout << "---------------------------------------------" << endl;
        cout << " " << endl;
        for (int i = h; i <= t; i++)
        {
            cout << "  " << i << ". "
                 << "Automobilio pavadinimas: " << cars[i].name << endl;

        }
    }
}

void retrieve(int i)
{
    if ((i >= h) && (i <= t))
    {
        cout << "          INFORMACIJA APIE AUTOMOBILI          " << endl;
        cout << "-----------------------------------------------" << endl; 
        cout << "  Pavadinimas: \"" << cars[i].name << "\"" << endl
             << "  Skaicius sandelyje: " << cars[i].number << endl
             << "  Ar nuomuojama (0-ne / 1-taip): " << cars[i].given << endl
             << "  Ar yra laisvu automobiliu (T / N): " << cars[i].isFree << endl
             << "  Buvo uzsakyta: " << cars[i].countAll << endl << endl;
    }
    else
        cout << "  Pasirinkote neteisinga vieta!" << endl;
}

void Delete(int i)
{
    if ((i >= h) && (i <= t))
    {
        cout << " " << endl;
        cout << "  Automobilis " << cars[i].name << " istrintas.\n";
        cout << " " << endl;
        
        for (int j = i; j < t; j++)
        {
            cars[j].name = cars[j+1].name;
            cars[j].number = cars[j+1].number;
            cars[j].given = cars[j+1].given;
            cars[j].isFree = cars[j+1].isFree;
            cars[j].countAll = cars[j+1].countAll;
        }
        t--;
    }
    else
        cout << "  Pasirinkote neteisinga vieta!\n";
}

void kill(int size)
{
     t = 0;
     h = 0;
     initialize(h, t);
}

void load()
{
    int count = 0;
    ifstream dataFile;
    dataFile.open("data.txt");
    dataFile >> count;
    if (count > 0)
    initialize(1, count);
    for (int i = h;  i <= count;  i++)
    {
        dataFile >> cars[i].number >> cars[i].given >> cars[i].isFree >> cars[i].countAll;
        dataFile.ignore(INT_MAX, ' ');
        getline(dataFile, cars[i].name);
    }
    dataFile.close();
}

void save()
{
    ofstream dataFile;
    dataFile.open("data.txt");
    dataFile << t << endl;
    if (t != 0)
    {
        for (int i = h;  i <= t;  i++)
        {
            dataFile << cars[i].number << " "
                     << cars[i].given << " "
                     << cars[i].isFree << " "
                     << cars[i].countAll << " "
                     << cars[i].name  << endl; 
         }
     }
     dataFile.close();
}

void showNext()
{
    for (int i = h; i <= t; i++)
    {
        cout << i << ". \t"
             << cars[i].name << " -> " << cars[i+1].name <<  "\n";
    }
}
